set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000253';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4223214',
      NULL,
      1,
      26.199220,
      3,
      3.955216,
      0.659566,
      NULL,
      85.743739,
      0,
      1,
      1,
      2,
      2.641856,
      1.266197,
      1,
      3.793518,
      NULL,
      1,
      0.849175,
      0.212564,
      0,
      3.771199,
      NULL,
      NULL,
      NULL,
      3,
      0.823821,
      1,
      0,
      2,
      0,
      0.161623,
      NULL,
      1,
      NULL,
      NULL,
      0.998387,
      1.601951,
      0.927911,
      2.198674,
      3,
      2.439228,
      NULL,
      3,
      1.374153,
      0.925266,
      0.384291,
      2.980140,
      1.238389,
      2.539710,
      0.075818,
      1.566260,
      1.897327,
      0.152486,
      1,
      0,
      0,
      0.401362,
      1,
      3.977987,
      0.770935,
      1.765173,
      0,
      NULL,
      0,
      2.935211,
      1,
      1.522738,
      0,
      1.231257,
      1.411449,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0.047974,
      1.120471,
      1.050557,
      0.988078,
      0,
      0.691050,
      0,
      0,
      1.476707,
      0.996039,
      0.065525,
      1.687217,
      1,
      0.048600,
      0,
      0.620899,
      1.803436,
      1.690086,
      1.294018,
      3.527717,
      NULL,
      NULL,
      3,
      3,
      2.128299,
      0.407446,
      NULL,
      4,
      NULL,
      '024',
      '404',
      ' 5-26-2001');
commit;
end;
/


