set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4320321',
      1,
      2,
      19.092771,
      0.651994,
      0.528700,
      NULL,
      NULL,
      48.044031,
      0.397885,
      0,
      2.820997,
      1,
      NULL,
      1.212698,
      1.466036,
      NULL,
      0,
      1.430978,
      1.055624,
      1,
      1,
      2.909549,
      1,
      NULL,
      0,
      1.472364,
      0,
      NULL,
      1,
      0.490192,
      NULL,
      1,
      0,
      NULL,
      1.444299,
      1.447557,
      1.389149,
      1.752774,
      0.044392,
      0.156576,
      0.504450,
      2.988145,
      NULL,
      0,
      0,
      NULL,
      1,
      1.058042,
      NULL,
      NULL,
      0.584170,
      0,
      1.080610,
      1.729043,
      1,
      0,
      1.808711,
      0.682967,
      0.633917,
      3.838417,
      1.169252,
      1,
      0,
      NULL,
      0.522284,
      NULL,
      1,
      0,
      1.325951,
      0,
      0.157014,
      1,
      0,
      3.008760,
      NULL,
      0.869797,
      1,
      0.307584,
      0.275277,
      1,
      1.410396,
      1.670831,
      0,
      2.088151,
      1,
      0,
      1,
      1,
      0.104124,
      NULL,
      NULL,
      1.279569,
      3,
      1.552518,
      0.498535,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.246895,
      3.225551,
      3,
      NULL,
      18.453274,
      1.947302,
      NULL,
      '430',
      ' 1- 8-1981');
commit;
end;
/


