set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9314038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0201434',
      1.031562,
      2,
      15.405026,
      3.043626,
      0,
      NULL,
      NULL,
      69,
      1,
      NULL,
      3,
      3.649926,
      1.697837,
      0.393314,
      1,
      3.785493,
      0.127372,
      1.378185,
      0,
      2,
      1,
      NULL,
      NULL,
      1.556623,
      NULL,
      1,
      0,
      2.633987,
      1,
      1.186783,
      NULL,
      0.054071,
      0.948879,
      1,
      NULL,
      0.678488,
      0,
      0,
      NULL,
      1,
      2,
      3,
      3,
      0.571927,
      0.725365,
      2,
      0,
      1.346745,
      1,
      3.123248,
      1,
      1.969151,
      1,
      0.240528,
      NULL,
      1.349544,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.625609,
      1.846783,
      2,
      1.223488,
      0,
      0.672796,
      1.434854,
      1.883929,
      1.132161,
      3.254607,
      NULL,
      0,
      2.136671,
      1.488130,
      0,
      1.625363,
      1,
      0,
      1,
      NULL,
      0.398515,
      1,
      0,
      1.432852,
      0,
      1.975547,
      1,
      0,
      NULL,
      0,
      0.680836,
      0.263108,
      0,
      1,
      NULL,
      1,
      0.406402,
      3.855096,
      3.085511,
      3,
      0.975754,
      14.956780,
      1,
      '310',
      NULL,
      ' 0- 6-1992');
commit;
end;
/


