set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7227432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0413420',
      1.949075,
      NULL,
      21,
      3,
      0,
      NULL,
      NULL,
      36,
      1.279309,
      1,
      NULL,
      3.190193,
      0,
      2.037122,
      1,
      0,
      1.138932,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.110790,
      0,
      0.036025,
      NULL,
      NULL,
      1.396938,
      1,
      NULL,
      0,
      1.136239,
      1.450935,
      0,
      0.770077,
      0,
      1,
      NULL,
      0.792912,
      NULL,
      1,
      2,
      2,
      0.933779,
      0.322118,
      2,
      1.824460,
      0,
      1,
      3.931643,
      1,
      0,
      1,
      1,
      0.000841,
      0.567789,
      1,
      NULL,
      1,
      3,
      1.223652,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0.782074,
      1,
      2.905275,
      NULL,
      1.074083,
      0,
      NULL,
      1,
      0.347729,
      1,
      NULL,
      0,
      1.863432,
      1.882308,
      NULL,
      NULL,
      1.923693,
      NULL,
      0,
      1.287288,
      1,
      NULL,
      0,
      NULL,
      0,
      1.462945,
      0.250087,
      1.902657,
      0,
      2.374612,
      1,
      NULL,
      1,
      1,
      7,
      3.244736,
      '002',
      NULL,
      NULL);
commit;
end;
/


