set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7303351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1412324',
      2.062639,
      0,
      29,
      2,
      NULL,
      NULL,
      NULL,
      9.750759,
      1,
      1.390753,
      1,
      3,
      0.110979,
      1.877941,
      1,
      0,
      0,
      1.318715,
      3.049829,
      0,
      1,
      3.766453,
      1,
      0.871694,
      NULL,
      1,
      2.191757,
      3,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      2.327293,
      1.058691,
      NULL,
      1,
      1.734834,
      NULL,
      2.152752,
      3.499232,
      2.622304,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.614696,
      0.338787,
      1,
      1.724724,
      3.389364,
      0,
      0.768413,
      1,
      NULL,
      3,
      0.233846,
      1.917417,
      0.824737,
      0,
      3,
      1.552404,
      0.828556,
      3,
      NULL,
      0,
      1.139795,
      NULL,
      0.342710,
      0.898693,
      2.194551,
      0,
      0.778376,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692563,
      0.197072,
      1,
      1.407377,
      1,
      0.501708,
      2,
      1.310153,
      1,
      0.894710,
      0,
      0,
      0,
      0.679594,
      NULL,
      1,
      0,
      NULL,
      3,
      3.247799,
      1,
      2,
      2,
      1,
      3.606457,
      3,
      '',
      '',
      '11-20-1990');
commit;
end;
/


