set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000158';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0324222',
      2,
      0,
      7.162669,
      3,
      NULL,
      0.997980,
      45.638407,
      1,
      NULL,
      NULL,
      0,
      0,
      0.563889,
      1.386445,
      NULL,
      NULL,
      NULL,
      0,
      1.942436,
      NULL,
      NULL,
      2,
      1,
      2,
      1.871082,
      3,
      NULL,
      0.448581,
      0.529886,
      3.186360,
      0,
      0.462603,
      0.937908,
      1,
      NULL,
      0.701920,
      0,
      0.406049,
      0.189131,
      3,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1.042373,
      1,
      1,
      0,
      0,
      NULL,
      0.000899,
      0.326484,
      NULL,
      NULL,
      0.202020,
      0,
      0.506473,
      0,
      0,
      NULL,
      NULL,
      0,
      0.653658,
      1,
      3.795359,
      NULL,
      1.967986,
      0,
      1,
      1.901831,
      0.090513,
      0.164933,
      3,
      1.614238,
      1.850436,
      1.070986,
      1.145245,
      0.648165,
      0.567783,
      0.707541,
      NULL,
      0.693165,
      0.495994,
      1,
      NULL,
      0,
      0.424292,
      0,
      0.262427,
      NULL,
      0.631667,
      NULL,
      1.906354,
      2,
      0.422550,
      2,
      1,
      NULL,
      2.680626,
      0,
      NULL,
      4.165213,
      NULL,
      '',
      '',
      ' 6-20-1975');
commit;
end;
/


