set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8104370';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1140101',
      3,
      1,
      32.055752,
      0.414179,
      0.859303,
      NULL,
      NULL,
      50.817870,
      1.318457,
      1,
      2.192698,
      3,
      NULL,
      NULL,
      3.728876,
      3.424623,
      0.939267,
      0,
      NULL,
      0.133346,
      NULL,
      NULL,
      1.987261,
      1,
      0,
      2,
      1.651704,
      1,
      NULL,
      NULL,
      1,
      0.463811,
      1,
      0.558188,
      1,
      1,
      1,
      1,
      1.021156,
      0,
      0.278962,
      0,
      NULL,
      1.482543,
      1,
      2,
      NULL,
      1.663376,
      1,
      3,
      1.378747,
      1.498656,
      0,
      0,
      NULL,
      1,
      0.375824,
      NULL,
      NULL,
      1.913278,
      0.563962,
      0.034373,
      0,
      1.041632,
      0,
      0.199933,
      0.433544,
      0.723516,
      NULL,
      1,
      0.229040,
      1,
      2.916478,
      2,
      1,
      1,
      1.608257,
      0.341804,
      0,
      NULL,
      1,
      1.453193,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.657950,
      0,
      NULL,
      NULL,
      0,
      1,
      1.833434,
      2,
      1.649301,
      NULL,
      2.998983,
      3.760997,
      0,
      2,
      0.410018,
      NULL,
      NULL,
      '',
      '',
      '10-10-1977');
commit;
end;
/


