set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6803034';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1341422',
      2.973762,
      2,
      NULL,
      3,
      0.527170,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      3.134710,
      NULL,
      1.383164,
      NULL,
      0.073895,
      NULL,
      1,
      1,
      1.447796,
      1,
      NULL,
      0.045481,
      3.222251,
      1.733452,
      1,
      0,
      0.912961,
      1,
      0.675956,
      NULL,
      0,
      0.032747,
      0.884998,
      0.332150,
      3.441641,
      1,
      NULL,
      1.873204,
      1,
      3,
      3,
      2.734648,
      3.425096,
      0.335293,
      1.407590,
      1,
      1,
      1.877501,
      2.151125,
      1,
      0,
      1.703911,
      3,
      NULL,
      0,
      1,
      0.984575,
      1.142798,
      NULL,
      NULL,
      0.339647,
      1.348315,
      0,
      0,
      1.925938,
      1,
      NULL,
      NULL,
      0,
      1.266834,
      0.873260,
      NULL,
      1.153964,
      0,
      0,
      1,
      1,
      NULL,
      0.993509,
      NULL,
      0,
      1.925822,
      1.398238,
      1.980148,
      NULL,
      NULL,
      0.575113,
      1,
      1.222008,
      1.516377,
      1.977651,
      0,
      NULL,
      2.525458,
      0,
      0.626171,
      0,
      0,
      2,
      2,
      2,
      3.680043,
      1,
      17,
      NULL,
      '',
      '',
      ' 5-27-1980');
commit;
end;
/


