set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7505780';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3412042',
      0.471013,
      1,
      10,
      1.163722,
      1.059779,
      NULL,
      NULL,
      5,
      1.442166,
      NULL,
      NULL,
      1.544398,
      0.625412,
      0.642101,
      0.985695,
      0,
      1,
      0.753280,
      1,
      NULL,
      1,
      NULL,
      1.866309,
      1.045268,
      1.711620,
      1,
      NULL,
      NULL,
      1,
      0.771829,
      0,
      1.170255,
      NULL,
      NULL,
      0.487986,
      NULL,
      0,
      0.831222,
      1.098388,
      0,
      NULL,
      1.437514,
      2,
      3,
      1.558106,
      0.988976,
      1,
      0.466495,
      0,
      0,
      NULL,
      1,
      0.597574,
      1.150202,
      1.846406,
      1.652374,
      1,
      0.899274,
      NULL,
      0.292550,
      0,
      NULL,
      NULL,
      0,
      0.016505,
      NULL,
      0,
      0.905474,
      0,
      1,
      1.011514,
      1.986216,
      2.168135,
      0,
      1,
      1.801100,
      1,
      1.084814,
      1.294806,
      1.207559,
      1,
      0.531310,
      1.868255,
      0,
      1.798405,
      NULL,
      1.640139,
      1.342288,
      0.791939,
      1,
      1.731174,
      0.115958,
      2.468793,
      0.525208,
      1,
      0,
      0.885220,
      1,
      NULL,
      3.839746,
      1,
      2,
      0,
      1.999344,
      NULL,
      2.230209,
      NULL,
      '',
      ' 5-29-1986');
commit;
end;
/


