set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000243';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4214130',
      3.763895,
      2,
      10,
      3.961666,
      1.211813,
      4.216109,
      NULL,
      42.037458,
      NULL,
      NULL,
      1.369289,
      NULL,
      1.065417,
      1.443523,
      2.693594,
      0,
      0.423624,
      1.400305,
      3,
      0.630004,
      1,
      1.100403,
      0.804493,
      0,
      1,
      3.513294,
      0.868601,
      0,
      0,
      3.160616,
      NULL,
      1,
      0,
      1,
      1.531330,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      2,
      3.939157,
      1.516170,
      0,
      1,
      0,
      3,
      0.043814,
      1.449944,
      1,
      1,
      NULL,
      0,
      1.953587,
      1,
      1,
      NULL,
      NULL,
      2.283830,
      1,
      0.541189,
      1,
      1.278938,
      NULL,
      NULL,
      NULL,
      2.447209,
      0.596206,
      0,
      0.031026,
      NULL,
      NULL,
      3,
      0.118710,
      0,
      0.300489,
      1.142440,
      1,
      0,
      0.545489,
      0,
      1,
      0,
      NULL,
      0,
      0.381127,
      1.848675,
      0.889048,
      1,
      0.701237,
      NULL,
      1.573705,
      0.768036,
      0.675660,
      0.287356,
      NULL,
      0.896290,
      NULL,
      0.556108,
      2,
      2.532413,
      1,
      0,
      NULL,
      3,
      '210',
      '031',
      '11- 2-1990');
commit;
end;
/


