set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8627636';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2004130',
      2.226199,
      3,
      20.143574,
      0.537387,
      NULL,
      NULL,
      NULL,
      30.373315,
      NULL,
      1.535701,
      NULL,
      2.505383,
      3,
      1,
      2,
      3.407539,
      0,
      0,
      1.723606,
      1,
      1,
      2.641344,
      NULL,
      2,
      0,
      0,
      NULL,
      1.667586,
      0,
      NULL,
      NULL,
      1,
      1,
      1.470575,
      0,
      2.960634,
      1.048009,
      1,
      NULL,
      1.592999,
      NULL,
      2,
      1,
      1.861962,
      1.467212,
      1.581200,
      1,
      NULL,
      0,
      2,
      0.908768,
      0,
      1.709084,
      1.756252,
      0.218930,
      0,
      0,
      0.428337,
      NULL,
      NULL,
      1,
      1.568900,
      NULL,
      NULL,
      1,
      1,
      0.240960,
      NULL,
      0,
      1,
      NULL,
      1.310087,
      1.117848,
      2,
      0.358377,
      1,
      0.924530,
      0,
      1.160218,
      1.304509,
      0,
      0.685310,
      0,
      1.734053,
      NULL,
      0.358874,
      1,
      1.873391,
      0.891956,
      0,
      NULL,
      0,
      1.635864,
      0,
      1,
      NULL,
      2.247427,
      0,
      3.776785,
      1.376140,
      2,
      0,
      0,
      NULL,
      1.248778,
      0,
      '013',
      '144',
      ' 8-29-1989');
commit;
end;
/


