set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115765';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4132411',
      NULL,
      3,
      4.844609,
      3,
      0.388673,
      NULL,
      NULL,
      39.200892,
      NULL,
      2.317000,
      0,
      0,
      3,
      0.642805,
      1,
      1.551960,
      1.609633,
      0,
      1.205467,
      1,
      0.950720,
      0.735461,
      0,
      2.418075,
      0,
      NULL,
      1,
      0.943734,
      1.938451,
      1.387790,
      NULL,
      0.919153,
      1.773237,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      2.241973,
      2,
      3,
      3,
      1,
      0,
      0.189407,
      0.062401,
      3.536418,
      0,
      3.966470,
      1,
      NULL,
      1,
      2,
      0,
      3.249956,
      0,
      NULL,
      3.089914,
      0.437944,
      0.951606,
      1.943894,
      1,
      2,
      0.812157,
      1.685261,
      1.009506,
      NULL,
      0,
      1.975497,
      0,
      1,
      3.708975,
      3,
      1,
      1.662763,
      0.652527,
      1.469829,
      1,
      0.467909,
      1,
      0.821143,
      NULL,
      1.608330,
      0.422631,
      1.722389,
      1,
      1.399656,
      1.010263,
      0.912122,
      0.513028,
      1,
      3.591467,
      0.086158,
      0.173953,
      1,
      1,
      1.687794,
      0,
      0.834320,
      NULL,
      3.947477,
      0,
      0.547592,
      13.807370,
      4.022694,
      '',
      '',
      NULL);
commit;
end;
/


