set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7018382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.556663,
      0,
      13,
      3.325890,
      NULL,
      NULL,
      NULL,
      60,
      0.661839,
      NULL,
      2.118298,
      0,
      NULL,
      0,
      NULL,
      3.692980,
      1.454036,
      1.827858,
      NULL,
      NULL,
      NULL,
      0.646770,
      NULL,
      NULL,
      0,
      1.812000,
      1.065460,
      0.538004,
      0.706380,
      NULL,
      1.642124,
      0.750843,
      NULL,
      1.614120,
      0,
      0.722255,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      3.149266,
      2.351806,
      0.806214,
      3,
      0.326965,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0.539045,
      0.399564,
      1,
      1,
      0.537917,
      2,
      1,
      1,
      0.963910,
      1.915685,
      2,
      0.887963,
      2.094103,
      1.174969,
      2.040397,
      1,
      1.059797,
      1.663690,
      NULL,
      3.239950,
      NULL,
      1,
      0.817219,
      1.840376,
      0.644386,
      0.316161,
      0.932088,
      0.413478,
      NULL,
      1,
      NULL,
      0,
      1.898188,
      NULL,
      0,
      1.522564,
      1.986677,
      0.791246,
      0,
      2.529228,
      NULL,
      1,
      0,
      0.343241,
      1,
      0,
      NULL,
      1,
      0.231668,
      0.888196,
      NULL,
      NULL,
      3.543056,
      '233',
      '301',
      ' 9-21-1981');
commit;
end;
/


