set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8932790';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1142233',
      2,
      2,
      32.106219,
      3.598572,
      1,
      NULL,
      NULL,
      25,
      0,
      NULL,
      1.718511,
      2,
      1.658174,
      NULL,
      0,
      3,
      1,
      1,
      0.089825,
      1,
      1.540033,
      2.333434,
      0.431019,
      NULL,
      1.557890,
      2.929020,
      NULL,
      0,
      1,
      3.100555,
      0,
      1,
      1.856364,
      1.638709,
      1.332529,
      3.055238,
      1.243768,
      0,
      1.476060,
      1.687302,
      NULL,
      2.431348,
      3.269629,
      NULL,
      0.700167,
      0,
      0.171322,
      0.826464,
      1,
      0,
      1.550869,
      NULL,
      0.778255,
      1,
      NULL,
      1,
      1.630541,
      NULL,
      0,
      2,
      0.158141,
      NULL,
      1,
      3,
      1.603644,
      2.499239,
      0,
      0.886660,
      0,
      0.799010,
      1.885548,
      NULL,
      0.843570,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.209411,
      0,
      NULL,
      1,
      1,
      NULL,
      3.356922,
      0,
      0.519052,
      0,
      1.284159,
      1.681490,
      2.898908,
      1.705373,
      1.020943,
      0,
      0,
      NULL,
      0.171150,
      2,
      0.060748,
      1,
      NULL,
      NULL,
      1.497119,
      6,
      4.314093,
      '104',
      NULL,
      ' 4- 4-1980');
commit;
end;
/


