set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3423014',
      1.215182,
      2,
      NULL,
      1.944044,
      3,
      2,
      17,
      7.080448,
      1.685287,
      1.955574,
      1,
      0.571279,
      0,
      0.812145,
      1.823281,
      1,
      1,
      1,
      NULL,
      0.217550,
      0.438434,
      1,
      NULL,
      2,
      1,
      NULL,
      0.744575,
      1,
      0,
      NULL,
      0.622740,
      3.583439,
      0.869701,
      0,
      NULL,
      0.303621,
      1,
      NULL,
      1.107461,
      0.910707,
      0.810415,
      0,
      3.507360,
      3,
      0.397311,
      0.607510,
      3,
      3.100432,
      0.688360,
      NULL,
      0.424118,
      0.826247,
      0.769048,
      NULL,
      1.252115,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.490104,
      2,
      0.648484,
      0.481753,
      1.763216,
      1,
      0,
      2.772624,
      1.523471,
      3,
      0,
      2,
      0.148206,
      1,
      0.866773,
      0,
      0.314014,
      0,
      0.868165,
      NULL,
      1.779074,
      NULL,
      1.663368,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.898677,
      0,
      1,
      1,
      NULL,
      0.438385,
      NULL,
      0.250962,
      NULL,
      1,
      24,
      6.871094,
      '',
      NULL,
      ' 1-27-1974');
commit;
end;
/


