set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005182';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0214234',
      2,
      1,
      26.101626,
      0,
      0.904161,
      NULL,
      NULL,
      38,
      0.437156,
      1.709285,
      2.558419,
      1.999741,
      1,
      1,
      NULL,
      1.734555,
      1,
      1.907111,
      0.412480,
      1.755057,
      1.484818,
      3,
      NULL,
      0.402642,
      0.616812,
      NULL,
      0,
      0,
      0.221535,
      0.479461,
      0.370353,
      0,
      1,
      NULL,
      NULL,
      3.107618,
      0.938823,
      0,
      1.091324,
      1,
      0,
      NULL,
      2.419680,
      2,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.955486,
      0,
      NULL,
      2.813188,
      NULL,
      1.502785,
      0,
      1,
      0,
      3.133166,
      1.686378,
      1.964368,
      0.688733,
      NULL,
      NULL,
      0,
      1.926208,
      1,
      0,
      1,
      0,
      1,
      3.353508,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.280813,
      0.031110,
      0.064089,
      1,
      NULL,
      NULL,
      1.587814,
      0,
      NULL,
      NULL,
      1.496588,
      NULL,
      0,
      0.976221,
      0.588322,
      1.603963,
      0,
      2,
      1,
      0.740779,
      NULL,
      1.342335,
      0,
      1,
      1.380098,
      3.256886,
      NULL,
      NULL,
      '442',
      NULL);
commit;
end;
/


