set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6111038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2334314',
      1,
      NULL,
      20.004848,
      0,
      0.185090,
      NULL,
      NULL,
      1.148388,
      1.365702,
      0.490653,
      NULL,
      NULL,
      1,
      0.445077,
      3.638715,
      3.408448,
      0.953473,
      1.385391,
      2.646851,
      1.999559,
      1.238181,
      1.158249,
      0,
      NULL,
      1,
      2,
      1.922632,
      0.170434,
      0,
      3.172795,
      0,
      1,
      1.371324,
      1.335220,
      1.846307,
      2.391949,
      1,
      0,
      1.561118,
      2.574605,
      0,
      3.598218,
      0,
      2,
      1,
      2.496068,
      NULL,
      1,
      0,
      0,
      0.702437,
      0,
      1,
      0.017508,
      NULL,
      1.050366,
      1,
      0.529732,
      1,
      2.183429,
      NULL,
      1,
      0,
      0,
      1,
      0.205707,
      1.824263,
      3.592862,
      1,
      1,
      0,
      0.384684,
      1.734934,
      2.442501,
      0.506229,
      3.858221,
      0,
      NULL,
      0.193628,
      0,
      1.763995,
      1.708650,
      0,
      1.022660,
      1.937236,
      1,
      0.718307,
      1,
      0.641157,
      1,
      0.642217,
      NULL,
      0.922728,
      0.847274,
      1,
      1,
      1.667638,
      0.145737,
      3,
      0.364955,
      1.347704,
      2,
      0,
      1.338611,
      7,
      1,
      '',
      '',
      '10-11-1988');
commit;
end;
/


