set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9008699';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0104302',
      2,
      1,
      8.866445,
      1,
      0,
      NULL,
      NULL,
      37,
      1.365328,
      3,
      NULL,
      0.732148,
      1.693179,
      0,
      0,
      0,
      0,
      1.927871,
      1,
      0.416411,
      0,
      2.154880,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282999,
      0.443908,
      0.080172,
      NULL,
      0.253732,
      2.392599,
      NULL,
      NULL,
      1,
      0,
      0.424922,
      1,
      0,
      3,
      3,
      1.136726,
      3.607923,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.832060,
      0.064695,
      1,
      0.130243,
      NULL,
      3.503570,
      0.101705,
      0.132049,
      NULL,
      1.617542,
      0.041850,
      0.759814,
      0,
      0,
      NULL,
      0,
      1.570019,
      1,
      3,
      1.936465,
      NULL,
      1.476282,
      0,
      0.739506,
      NULL,
      2.769547,
      0.675819,
      0,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      3,
      0.123103,
      NULL,
      0,
      NULL,
      1.353952,
      0.522314,
      1,
      0,
      0.604204,
      0.782814,
      1.779428,
      0,
      0.981795,
      0,
      2,
      2,
      0.597131,
      NULL,
      1,
      NULL,
      1.435065,
      8,
      21.030950,
      '',
      '',
      ' 6-26-1999');
commit;
end;
/


