set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7909319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2022011',
      3,
      NULL,
      22,
      NULL,
      0.737067,
      0,
      11.887088,
      51.798352,
      0,
      1.772870,
      NULL,
      0,
      NULL,
      1.846136,
      1,
      0.054830,
      1.890623,
      1.068376,
      1.236971,
      0.812065,
      NULL,
      0.045437,
      1,
      1,
      1,
      NULL,
      NULL,
      0.191862,
      0,
      3.142603,
      2,
      0,
      3,
      0.328408,
      0.044829,
      1.508211,
      NULL,
      3.962768,
      1,
      NULL,
      0,
      2.807826,
      3,
      NULL,
      1,
      0.891438,
      0,
      NULL,
      0.743091,
      1.807209,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      2.847544,
      1,
      0.926325,
      0.802625,
      1,
      NULL,
      3,
      NULL,
      1.070156,
      NULL,
      0,
      0.479626,
      1,
      3.200386,
      NULL,
      1,
      1.098435,
      NULL,
      1.473075,
      1.974503,
      0,
      2.424981,
      1,
      1.455731,
      1.305112,
      0,
      NULL,
      1,
      1.467667,
      1.453803,
      NULL,
      0.381686,
      3.212580,
      NULL,
      0,
      3,
      1.226870,
      3,
      NULL,
      0.163382,
      NULL,
      1.173370,
      1,
      2,
      0,
      6.013436,
      NULL,
      '',
      '',
      ' 8-12-1981');
commit;
end;
/


