set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4124020',
      1,
      2,
      NULL,
      0,
      2.412613,
      5.533712,
      39,
      7,
      0,
      3,
      0.253632,
      2.559676,
      0,
      1,
      0.642349,
      1,
      1,
      0.715616,
      0,
      1.814318,
      1,
      2.028830,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169399,
      1,
      NULL,
      2,
      0,
      1.851357,
      0,
      1,
      NULL,
      2.848606,
      0,
      1.975257,
      1,
      2,
      3,
      1.530030,
      1.731961,
      NULL,
      1.055639,
      1,
      1,
      3,
      1,
      3.537907,
      NULL,
      1,
      1.950072,
      1.756628,
      0.499003,
      0.057412,
      1.440126,
      0.480389,
      NULL,
      0.273334,
      1,
      1.900918,
      NULL,
      0,
      0.958805,
      0.397793,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0.940187,
      1,
      NULL,
      1,
      0.578179,
      1.603965,
      0,
      NULL,
      1.307832,
      0,
      NULL,
      1,
      1.339122,
      0.094921,
      0,
      NULL,
      0.315590,
      0.146145,
      1.238036,
      2.758944,
      NULL,
      0,
      0,
      0.013507,
      1.544395,
      0.321639,
      3,
      3.319498,
      0,
      2.101198,
      2.749291,
      1,
      3.551820,
      4,
      '',
      NULL,
      ' 1- 8-1994');
commit;
end;
/


