set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8825651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0301023',
      3,
      1,
      15,
      NULL,
      0.456117,
      NULL,
      NULL,
      48,
      0,
      0.337607,
      3,
      2.399141,
      2.012034,
      0,
      0,
      2.230346,
      1,
      1,
      1,
      0.854669,
      0.274519,
      2.605647,
      1.576027,
      3.464980,
      1.721411,
      2.213534,
      1.650051,
      1,
      0,
      0,
      1.627208,
      0.900638,
      1.718327,
      NULL,
      0,
      1.728256,
      1,
      NULL,
      1,
      0,
      NULL,
      1.415501,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      0.289807,
      1,
      1,
      NULL,
      1,
      3.838884,
      0,
      0.028813,
      0,
      1.184806,
      NULL,
      3.020357,
      NULL,
      3.872152,
      0.176183,
      NULL,
      1,
      1.693742,
      1,
      3,
      1.681658,
      1.594113,
      0,
      1,
      0,
      NULL,
      0.222763,
      0,
      1,
      1,
      1.597846,
      1.008577,
      0,
      NULL,
      1,
      0.003555,
      1,
      0,
      NULL,
      1.661660,
      1.932943,
      0,
      1,
      1.055528,
      1,
      0,
      2.892991,
      0.594066,
      1,
      0,
      4,
      1,
      '',
      '',
      NULL);
commit;
end;
/


