set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929907';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.864742,
      NULL,
      31,
      0.172339,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.525263,
      3,
      3.316054,
      0,
      2.548763,
      3.149153,
      0,
      0.641444,
      1,
      0.191173,
      NULL,
      NULL,
      NULL,
      2.697334,
      0.826808,
      3,
      NULL,
      1,
      0,
      0.606637,
      NULL,
      0.494267,
      NULL,
      0,
      1.632559,
      1,
      0.764103,
      1.162908,
      NULL,
      3,
      2.323625,
      2.844437,
      3,
      1,
      0.186096,
      0.588653,
      1.180536,
      1.062501,
      1.516211,
      3,
      0,
      1.433811,
      0,
      0,
      1.063208,
      0.897654,
      1.177042,
      0.331144,
      1.011130,
      3,
      0.640878,
      0.931824,
      1.335759,
      1,
      0,
      NULL,
      0.713670,
      NULL,
      1,
      1.421356,
      1,
      0,
      0,
      1.773541,
      NULL,
      1.004054,
      1,
      1.463919,
      1,
      0,
      1.429273,
      0.125520,
      0.243733,
      0,
      0.941985,
      0,
      0.413827,
      0,
      1.988634,
      0,
      2.979252,
      1.026182,
      0,
      1,
      0,
      NULL,
      3,
      1,
      2,
      3,
      3.902814,
      NULL,
      NULL,
      0.600188,
      2.091394,
      4,
      NULL,
      '102',
      ' 3- 6-1976');
commit;
end;
/


