set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8532145';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0410430',
      3.096424,
      1,
      23.231317,
      3,
      2.028276,
      NULL,
      4.457676,
      7.742513,
      1.248728,
      2.582931,
      0.801443,
      NULL,
      2.942054,
      1.042553,
      NULL,
      3.195898,
      NULL,
      1,
      2,
      0,
      1.003539,
      1.904025,
      1.664677,
      3.106547,
      1,
      NULL,
      0.937987,
      0,
      0.335271,
      0.856496,
      0,
      0,
      1,
      3,
      0,
      1.956927,
      0.647757,
      1.040536,
      1.267941,
      2.932076,
      0,
      NULL,
      0.238291,
      NULL,
      1.290954,
      3.288150,
      1.156050,
      NULL,
      1.506948,
      0,
      1.578911,
      NULL,
      0,
      NULL,
      1.503649,
      0.066351,
      0.799152,
      1.524308,
      3,
      2.463782,
      0.323782,
      0.361600,
      1,
      NULL,
      1,
      3,
      1.329842,
      0.051845,
      1.686076,
      0.799122,
      1.490442,
      0.715640,
      2,
      0,
      NULL,
      1.411140,
      0.864648,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.938800,
      1,
      NULL,
      1.734336,
      1.014385,
      0.340837,
      NULL,
      2,
      NULL,
      1.241358,
      NULL,
      1.014176,
      1,
      0.225475,
      1,
      0.775867,
      NULL,
      2.197292,
      1.299457,
      1.033076,
      9,
      0.394936,
      '',
      '',
      ' 6-11-1989');
commit;
end;
/


