set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5102105';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1343124',
      0.932409,
      1,
      31.673470,
      2.019609,
      0.860002,
      NULL,
      NULL,
      7,
      1,
      3.112570,
      1,
      0,
      0,
      1.522848,
      NULL,
      NULL,
      NULL,
      0.664375,
      NULL,
      3,
      1.543871,
      2,
      0,
      1,
      1.044967,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.293129,
      1.570972,
      0.278100,
      NULL,
      1.504877,
      3,
      2.468604,
      NULL,
      NULL,
      0.800453,
      0,
      0,
      0.772542,
      NULL,
      0.020081,
      2.731665,
      NULL,
      1.650396,
      0.698496,
      1,
      1.804160,
      0,
      3,
      0,
      3.269957,
      2.383656,
      1.340363,
      NULL,
      1,
      NULL,
      NULL,
      2.224235,
      NULL,
      NULL,
      NULL,
      1,
      0.101747,
      1,
      2,
      1.517849,
      1,
      NULL,
      0.391677,
      0,
      0.078284,
      0,
      1.988938,
      1,
      1.795498,
      1.561776,
      0,
      1,
      1.144814,
      2.432829,
      NULL,
      NULL,
      1.960645,
      0,
      NULL,
      1,
      NULL,
      0,
      1.046401,
      0,
      1,
      0.379598,
      3.222844,
      3.256315,
      2,
      NULL,
      9,
      7,
      NULL,
      '',
      ' 1-13-1979');
commit;
end;
/


