set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919099';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1202124',
      3.815015,
      0,
      1,
      0.001480,
      1.836089,
      NULL,
      NULL,
      15,
      0,
      NULL,
      2,
      1,
      0.674342,
      2.153346,
      2,
      1.384149,
      0,
      0,
      3.423454,
      0.671096,
      NULL,
      3,
      1.740322,
      NULL,
      0,
      0.049943,
      0.765955,
      1.766995,
      NULL,
      0,
      0,
      1.549085,
      0,
      0,
      1,
      3.943643,
      1.424657,
      0,
      1,
      3.868632,
      1.145166,
      NULL,
      2.803796,
      0.948248,
      2,
      1,
      3.274591,
      3.706670,
      1.128159,
      NULL,
      NULL,
      2,
      1.210832,
      1.095615,
      0.209125,
      1.433020,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.558076,
      1.375554,
      2.085904,
      1.690816,
      2.779453,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.987181,
      0,
      0.502065,
      1.022200,
      1,
      1.875264,
      1,
      0.779261,
      2,
      1.511717,
      NULL,
      1.384641,
      1.933970,
      NULL,
      NULL,
      1.116256,
      NULL,
      NULL,
      0.721989,
      1,
      1.299224,
      0,
      NULL,
      1.422754,
      2.881951,
      2,
      2.916726,
      2,
      0.080961,
      0,
      23.304202,
      23.819098,
      '020',
      '341',
      ' 1- 2-2002');
commit;
end;
/


