set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9200587';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3402013',
      0.925675,
      1,
      6.960770,
      2.452667,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920886,
      3.617777,
      1.665893,
      2,
      0.490059,
      0,
      NULL,
      0.120159,
      NULL,
      0.558984,
      1.964385,
      0,
      0.709135,
      NULL,
      0.385537,
      0,
      0.133144,
      NULL,
      1.408336,
      0,
      1.298613,
      3,
      1.807324,
      0.361647,
      1.272841,
      0,
      NULL,
      1.594132,
      1,
      1.769199,
      NULL,
      3,
      3.292942,
      2.944893,
      3,
      1.506302,
      NULL,
      2.145400,
      1.792027,
      NULL,
      1.189753,
      0,
      1,
      1.937620,
      NULL,
      NULL,
      1.515050,
      1,
      1,
      1,
      NULL,
      1.289903,
      1,
      NULL,
      0,
      0,
      0,
      3,
      0.929993,
      NULL,
      0.669078,
      0.888709,
      0.283563,
      0.569378,
      1,
      0,
      1.833014,
      1.640123,
      1,
      NULL,
      NULL,
      NULL,
      1.843588,
      0,
      0,
      1.479116,
      1,
      0,
      1,
      0,
      1.808009,
      0.394892,
      0,
      0.992628,
      1,
      1.913065,
      1.051033,
      0.172214,
      0.890674,
      NULL,
      2,
      0,
      2,
      2.636944,
      0.523623,
      0.402953,
      NULL,
      2.512114,
      '331',
      '041',
      ' 0-22-1985');
commit;
end;
/


