set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000254';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2301303',
      2,
      3,
      11,
      0,
      0.976705,
      NULL,
      NULL,
      NULL,
      0,
      3.139537,
      NULL,
      3,
      3,
      0.467213,
      3,
      3.409744,
      1.134257,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      2.793777,
      1.248380,
      0,
      1,
      1,
      1,
      1.136008,
      0,
      0.604692,
      0.256709,
      NULL,
      1.165973,
      NULL,
      0.478088,
      NULL,
      0.154250,
      0.188080,
      NULL,
      2.158584,
      NULL,
      NULL,
      NULL,
      1.491661,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.565869,
      NULL,
      0,
      1.968100,
      0,
      1.263454,
      1.573352,
      0.561748,
      1,
      0.542986,
      0,
      1,
      NULL,
      0,
      0.299468,
      NULL,
      0.863338,
      1,
      0.382785,
      1.317112,
      3.261313,
      2.192793,
      1.366586,
      NULL,
      1,
      0.365567,
      0.472841,
      0,
      1,
      1.869163,
      1.889648,
      NULL,
      1,
      1.300071,
      0.676038,
      NULL,
      0,
      NULL,
      0.390413,
      2,
      2.846405,
      NULL,
      1,
      1,
      1,
      3.355686,
      2.980257,
      3.309329,
      1,
      3,
      1,
      0.380132,
      4.798062,
      NULL,
      '024',
      '333',
      ' 0- 3-1988');
commit;
end;
/


