set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331679';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0401334',
      NULL,
      2,
      NULL,
      1,
      0.986786,
      NULL,
      NULL,
      43.344874,
      0.406135,
      0,
      0,
      NULL,
      3,
      NULL,
      3,
      2,
      0,
      1.533911,
      0.503985,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.948847,
      1.933150,
      0.449851,
      1,
      NULL,
      0.866169,
      NULL,
      1,
      0.528385,
      0,
      1,
      NULL,
      2.895629,
      1,
      0.366298,
      2,
      1,
      NULL,
      1,
      1.188325,
      0.897304,
      3,
      1.806854,
      1.076512,
      NULL,
      1.032150,
      1,
      0.773173,
      1.652359,
      NULL,
      1,
      3,
      2.010776,
      0,
      0,
      NULL,
      1.246678,
      1,
      0.021416,
      1,
      NULL,
      0.609696,
      2.084149,
      1,
      NULL,
      NULL,
      1,
      1.634154,
      1.729261,
      1,
      3.805253,
      1,
      0.820651,
      NULL,
      0.028517,
      NULL,
      1.517804,
      1.819905,
      0,
      1,
      0.853807,
      0.166168,
      0.560067,
      0,
      1.005980,
      2.349531,
      0,
      0.153423,
      0.683903,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0.887691,
      1,
      8,
      '331',
      '434',
      ' 0- 6-1983');
commit;
end;
/


