set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000184';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3120042',
      0,
      NULL,
      NULL,
      1,
      1,
      4,
      60.506051,
      67.575253,
      0,
      3.453867,
      NULL,
      NULL,
      NULL,
      0,
      3.844758,
      3,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.749524,
      1.983468,
      NULL,
      0.194136,
      2.928919,
      0.649254,
      1.603680,
      0.443292,
      1.982132,
      0.299131,
      0.853469,
      0.273266,
      0,
      1,
      2.383844,
      1,
      0,
      0,
      2.391744,
      3.709777,
      0,
      1.463295,
      2.656787,
      1,
      3,
      1.535498,
      1,
      1.554268,
      NULL,
      1,
      1,
      NULL,
      0,
      1.937669,
      1.312225,
      NULL,
      3,
      1.470218,
      NULL,
      0,
      0.621625,
      1,
      1,
      0,
      3,
      NULL,
      2.387941,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1.746180,
      1,
      1.687945,
      0,
      1.217254,
      0.513994,
      0,
      0.485560,
      0,
      0,
      0.177921,
      0,
      NULL,
      NULL,
      NULL,
      1.419235,
      1,
      1,
      NULL,
      0,
      0,
      0.803915,
      1.044264,
      0,
      3,
      1.792683,
      2.958317,
      NULL,
      2.872576,
      NULL,
      1.684344,
      2.331232,
      '',
      '',
      NULL);
commit;
end;
/


