set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7936412';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3441124',
      1,
      0,
      NULL,
      2,
      1.601632,
      NULL,
      NULL,
      46,
      1.332511,
      2.835316,
      1,
      1,
      0,
      1,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.832568,
      2.741839,
      0,
      NULL,
      NULL,
      NULL,
      1.967233,
      NULL,
      0,
      1,
      1,
      0,
      1.649177,
      3,
      1,
      NULL,
      1,
      0.798546,
      2,
      1.749430,
      0,
      3,
      1.475020,
      3,
      0.936038,
      1.398890,
      0.976898,
      3,
      0.944026,
      0.570960,
      1.845942,
      0.183426,
      0.288064,
      1,
      0,
      1.914000,
      0,
      2.096844,
      1,
      0.718570,
      1.107182,
      1,
      0.650014,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.431068,
      0.354427,
      1.940457,
      0.640713,
      1,
      1.123851,
      0,
      0.981634,
      0.561544,
      1.716629,
      0,
      1.734928,
      1.105401,
      0.732243,
      0,
      0,
      3,
      3,
      0,
      NULL,
      0.790432,
      NULL,
      1.603256,
      0.493869,
      3.624395,
      2,
      1,
      2.105595,
      0.660240,
      2.785564,
      2.113004,
      '',
      '',
      NULL);
commit;
end;
/


