set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8629473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0024314',
      2.196309,
      3,
      NULL,
      2.314622,
      0,
      NULL,
      NULL,
      32.047438,
      1,
      3,
      NULL,
      1.105800,
      2,
      1.444899,
      1,
      2.794657,
      1.373432,
      1.614324,
      1,
      1,
      1,
      3.091491,
      0,
      1.508009,
      NULL,
      2,
      1.051340,
      1,
      1,
      1,
      1.564564,
      1.806505,
      0.557628,
      1,
      1,
      NULL,
      0.171697,
      1,
      0,
      1,
      2.878508,
      3,
      0.040223,
      1,
      0.650086,
      0,
      NULL,
      3,
      1,
      1,
      2.682439,
      NULL,
      1.079595,
      0,
      0.574295,
      0.757002,
      0,
      0,
      1.538732,
      3,
      1,
      1.110849,
      1,
      1,
      0,
      1.911616,
      0.917886,
      1.515789,
      0,
      1.428380,
      1.007747,
      0,
      1,
      0,
      1,
      0.057478,
      1.912343,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1.645854,
      1,
      0.211163,
      NULL,
      NULL,
      0,
      NULL,
      0.076540,
      3,
      NULL,
      1,
      0.365253,
      1.872334,
      0.624185,
      NULL,
      3.747457,
      1.356667,
      2.529331,
      1,
      0.635504,
      5,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


