set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8507236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0404324',
      0.987043,
      3,
      16,
      1.026779,
      0.272825,
      2.318874,
      60,
      9,
      0.620147,
      0,
      1,
      0.546015,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.176042,
      0.486293,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      0.854526,
      2,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      0.179238,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.566246,
      2,
      1.616039,
      0.533541,
      NULL,
      1,
      1.838952,
      0.707592,
      1.795544,
      1.714794,
      1,
      1,
      NULL,
      1,
      2.887372,
      0,
      1.865488,
      0.673843,
      0.391665,
      1.781842,
      0,
      NULL,
      0.281570,
      1.653340,
      0.601430,
      0,
      NULL,
      1.338876,
      1,
      1,
      0,
      NULL,
      0.652229,
      1,
      2,
      1.774418,
      1,
      0,
      1,
      1.080926,
      1,
      NULL,
      2.289164,
      1,
      1,
      NULL,
      1,
      1.329748,
      1.093113,
      0,
      NULL,
      1,
      NULL,
      0.205989,
      0.033556,
      0,
      3.689931,
      1,
      0.038791,
      0.305667,
      2,
      0.001210,
      0,
      21.686708,
      3.694660,
      NULL,
      NULL,
      NULL);
commit;
end;
/


