set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9028689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2,
      20,
      2.567535,
      1.357281,
      NULL,
      NULL,
      20,
      0,
      1,
      2,
      0.214990,
      1,
      0,
      1.784377,
      NULL,
      0.467052,
      0,
      1.300871,
      0.227563,
      1.003856,
      1,
      0.111734,
      0.077572,
      1.064831,
      NULL,
      0.169983,
      3,
      1.827437,
      1,
      1,
      0,
      1,
      0.119178,
      1,
      3.188209,
      1,
      0,
      1,
      1.616521,
      NULL,
      3,
      1,
      2.103384,
      1,
      3.012728,
      1,
      NULL,
      1.372699,
      3.850757,
      1,
      NULL,
      1.650190,
      1.635036,
      1.911073,
      1.491730,
      0,
      1,
      2.745832,
      1.108711,
      0.620940,
      0,
      NULL,
      1,
      1,
      1.991645,
      NULL,
      0,
      1.027447,
      1,
      NULL,
      1.659174,
      0.504929,
      0.689278,
      0.127018,
      NULL,
      0,
      0.658680,
      3.205922,
      1,
      1,
      0,
      1.615176,
      1,
      0,
      1,
      0.585493,
      NULL,
      0.021766,
      1,
      0,
      1,
      1,
      1,
      1,
      1.338498,
      2.956346,
      1,
      0,
      3,
      3,
      0,
      NULL,
      1.599370,
      28,
      3,
      '',
      '',
      ' 7- 9-1986');
commit;
end;
/


