set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9434885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4104201',
      2,
      1,
      18,
      1.990865,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      2.022686,
      0,
      NULL,
      1.034073,
      0.676812,
      3.423935,
      NULL,
      1.288660,
      NULL,
      0.648919,
      0,
      2,
      NULL,
      0.582337,
      1.544061,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.984103,
      0,
      NULL,
      1,
      1.452279,
      1.941041,
      NULL,
      1,
      1,
      1.886006,
      1.579895,
      2,
      3,
      2,
      NULL,
      1.568909,
      1.165426,
      0.252055,
      3,
      NULL,
      NULL,
      1,
      1.825932,
      NULL,
      1.958655,
      1,
      0.805490,
      NULL,
      1.984261,
      NULL,
      3,
      0.944408,
      0.443139,
      1,
      NULL,
      1.786443,
      NULL,
      NULL,
      2.822003,
      1,
      1,
      1.843336,
      1.502680,
      1,
      2.615721,
      1.169894,
      0.000632,
      NULL,
      1,
      1.272575,
      NULL,
      NULL,
      0.956499,
      0.577508,
      0,
      0.294484,
      2.047947,
      1,
      1.642803,
      0.579509,
      NULL,
      0.463658,
      3,
      NULL,
      NULL,
      0,
      1.725789,
      0.607426,
      1,
      2,
      2.875407,
      0.160852,
      2,
      1,
      1.940681,
      NULL,
      NULL,
      '040',
      '32',
      ' 3-15-1986');
commit;
end;
/


