set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119792';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1021024',
      3,
      1,
      NULL,
      NULL,
      1.286767,
      NULL,
      NULL,
      58,
      NULL,
      1,
      2,
      0,
      1,
      0,
      0.925364,
      3.930985,
      NULL,
      1,
      NULL,
      0.092956,
      0,
      2.582236,
      0,
      0.203475,
      1.703348,
      NULL,
      1,
      0.620751,
      0,
      0,
      0,
      NULL,
      1.797009,
      0,
      NULL,
      3.587575,
      0.129407,
      NULL,
      0.489552,
      3,
      2.383065,
      2.595772,
      1.899923,
      1.684579,
      NULL,
      1,
      1.957060,
      1.910050,
      NULL,
      0.197311,
      1.826765,
      0.408784,
      1.804912,
      0.289362,
      NULL,
      0.919351,
      NULL,
      1,
      NULL,
      3.563856,
      0.979902,
      0.883681,
      0.452733,
      0.034268,
      1,
      1.571335,
      1.667977,
      2,
      NULL,
      1.554362,
      1,
      0.242486,
      1.961336,
      2,
      NULL,
      1.828043,
      0,
      NULL,
      1.086746,
      1,
      0,
      1.175668,
      0.888872,
      1.830798,
      1,
      1.313087,
      NULL,
      0,
      1.379428,
      0,
      0,
      1.385049,
      0,
      1,
      0.641465,
      NULL,
      NULL,
      1.003961,
      NULL,
      0,
      0.234107,
      NULL,
      3,
      1.529164,
      16,
      4.941718,
      '024',
      '001',
      ' 2- 7-1978');
commit;
end;
/


