set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.652179,
      1,
      34.648247,
      2,
      1.033490,
      NULL,
      NULL,
      69,
      1,
      2,
      1,
      NULL,
      0,
      0,
      2.642963,
      2.283341,
      0.234214,
      0.870500,
      3,
      0,
      NULL,
      1.372121,
      1,
      NULL,
      0.676770,
      NULL,
      1.641264,
      NULL,
      1.934200,
      0.450441,
      0,
      1,
      0.011170,
      0,
      NULL,
      1,
      0,
      0,
      0,
      2.551704,
      0,
      1,
      0.852446,
      3.935679,
      1.378809,
      1,
      0,
      1,
      1.805121,
      1.134842,
      0,
      0,
      0.394053,
      NULL,
      0.697663,
      0,
      0,
      1.710753,
      1.715620,
      NULL,
      0.044035,
      1,
      NULL,
      NULL,
      NULL,
      0.506219,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.552137,
      1,
      0.575743,
      0,
      NULL,
      0.604885,
      0.308167,
      0,
      NULL,
      0.302391,
      1,
      0.209782,
      NULL,
      0,
      0.726364,
      NULL,
      0.020591,
      1.581006,
      0,
      1,
      3,
      1.076138,
      0,
      1,
      1,
      1.835765,
      NULL,
      2.284041,
      2,
      2,
      1,
      NULL,
      3.709009,
      3,
      NULL,
      '213',
      ' 0- 4-1975');
commit;
end;
/


