set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3241400',
      NULL,
      0,
      NULL,
      2,
      1,
      5.763318,
      2,
      29.854775,
      0.118776,
      0,
      3,
      0.965109,
      2,
      0.455854,
      3.362260,
      0.354789,
      1.858988,
      0,
      0,
      0,
      0,
      3,
      1,
      0.383671,
      1,
      1.999599,
      0,
      0,
      1.011253,
      2,
      0.779682,
      1,
      1.908643,
      0,
      0,
      3.760044,
      NULL,
      NULL,
      0.307601,
      NULL,
      0.533777,
      2.646410,
      3.678515,
      3,
      1.648567,
      0.747792,
      1,
      2.142847,
      NULL,
      1,
      1,
      1.446918,
      NULL,
      1,
      1.493835,
      0,
      1,
      1.174611,
      3.265135,
      0,
      0,
      0.201573,
      NULL,
      2,
      0.270754,
      2,
      0,
      0.791804,
      1,
      0,
      1,
      NULL,
      1.359517,
      3,
      1,
      0.495273,
      0,
      NULL,
      0,
      0,
      0.932842,
      NULL,
      1.543045,
      0.212070,
      0.566198,
      NULL,
      NULL,
      0,
      0.869227,
      1.194982,
      1,
      0.550412,
      0.819894,
      1,
      3,
      0,
      1.574812,
      0.633082,
      1.325986,
      1.796305,
      NULL,
      3,
      1.429653,
      0.395970,
      NULL,
      0.321058,
      '',
      '',
      NULL);
commit;
end;
/


