set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6310169';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4033442',
      0.636865,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      37,
      1.747119,
      0.199025,
      0,
      2.698014,
      0,
      0,
      0.680165,
      2,
      NULL,
      0,
      1,
      1,
      0.095165,
      1.629455,
      1.957687,
      NULL,
      0.161656,
      2,
      2.388369,
      1.546797,
      0.498395,
      0.579167,
      NULL,
      NULL,
      NULL,
      1.861912,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      0,
      0.377906,
      NULL,
      0,
      0.799335,
      1,
      2.748324,
      1,
      2.370622,
      1.065231,
      1,
      1.009375,
      1,
      0,
      1.843526,
      NULL,
      1.780619,
      3,
      NULL,
      1,
      1.343878,
      0.671452,
      NULL,
      1,
      1.454948,
      0,
      1,
      0,
      NULL,
      0.702460,
      1,
      2,
      NULL,
      0.310992,
      0,
      0,
      0.124115,
      NULL,
      1.147699,
      0.359032,
      1,
      1.577028,
      1.858569,
      0.279110,
      0,
      1.397556,
      1.065130,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.570590,
      NULL,
      1.458757,
      1,
      0,
      NULL,
      1,
      1,
      2.268559,
      1.662665,
      1,
      7,
      6.123349,
      '',
      NULL,
      '11- 2-1994');
commit;
end;
/


