set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127350';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0140310',
      1,
      3,
      30,
      3.864128,
      NULL,
      NULL,
      NULL,
      35.224588,
      1.635750,
      NULL,
      2.275212,
      1.926460,
      NULL,
      1,
      NULL,
      3.501144,
      NULL,
      1.319139,
      3,
      0.197741,
      1,
      1.111483,
      0.595250,
      2.022239,
      0,
      2.329155,
      NULL,
      0,
      1.770147,
      3,
      1,
      0.672091,
      0,
      NULL,
      0.266120,
      0.642480,
      0,
      0,
      1,
      3.980405,
      1,
      0.938804,
      3,
      0,
      0,
      NULL,
      0.728028,
      0,
      0,
      1.256180,
      0,
      NULL,
      1,
      1.222208,
      1.396438,
      0.964636,
      0.395747,
      0.251673,
      2.425844,
      1,
      0,
      1.627987,
      1,
      NULL,
      0.616149,
      2.403628,
      NULL,
      0.718369,
      1.005789,
      1,
      0.159797,
      1.138640,
      1,
      2,
      NULL,
      1,
      0.881398,
      0.908087,
      0,
      1,
      0,
      1.130452,
      1,
      1,
      1.942170,
      1,
      1.241000,
      NULL,
      NULL,
      1,
      0,
      3.893982,
      2.335143,
      NULL,
      0.353440,
      NULL,
      1.182442,
      NULL,
      0,
      0.785415,
      3.532044,
      NULL,
      1.955808,
      1.384550,
      7.341694,
      NULL,
      '',
      NULL,
      '10-23-1978');
commit;
end;
/


