set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000089';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3204132',
      2,
      2,
      23.807959,
      NULL,
      2.288674,
      NULL,
      10,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.638667,
      NULL,
      0.212028,
      0.469825,
      1,
      1,
      0.261835,
      NULL,
      0.841050,
      1.059304,
      0,
      3,
      1,
      3.956214,
      1.856995,
      1,
      NULL,
      0,
      1.763170,
      NULL,
      0,
      1,
      0.403760,
      0.267286,
      1.015401,
      0.105113,
      NULL,
      1.626030,
      NULL,
      0.993698,
      0,
      0,
      0.349792,
      0.150578,
      0.527907,
      2.575510,
      NULL,
      0.804849,
      0.163828,
      NULL,
      0.994754,
      0.104131,
      NULL,
      1.051341,
      NULL,
      0.742669,
      1,
      1.424721,
      0.489183,
      1.477100,
      1.944429,
      1.649848,
      1.588111,
      1,
      1,
      0.363149,
      0.085992,
      1,
      2.660333,
      NULL,
      1,
      1.769173,
      NULL,
      0,
      0.234186,
      0.546592,
      0.731610,
      0,
      0.332054,
      0,
      1.948594,
      NULL,
      NULL,
      1,
      0.708674,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.168255,
      1,
      NULL,
      0.006205,
      3,
      3,
      1.469505,
      NULL,
      0.038000,
      0.413494,
      27,
      1,
      '',
      '',
      ' 3-16-1987');
commit;
end;
/


