set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3400331',
      3,
      NULL,
      NULL,
      1.507801,
      1.576081,
      5.699195,
      17.244914,
      10,
      0.970198,
      0.297960,
      NULL,
      2,
      1.302867,
      1.498744,
      NULL,
      1,
      1.814060,
      1.705022,
      0,
      0,
      1,
      2,
      1.083657,
      NULL,
      0.838813,
      2.920146,
      0.057309,
      NULL,
      NULL,
      2,
      1,
      2,
      0.403879,
      1,
      1.055735,
      2.192766,
      NULL,
      1,
      0,
      1.547385,
      NULL,
      1,
      2.614221,
      3,
      0,
      3.764511,
      1.087417,
      1.490243,
      0,
      1.152593,
      1,
      1,
      0,
      NULL,
      0.614476,
      NULL,
      1,
      NULL,
      1,
      1.552606,
      0,
      1,
      0.575238,
      0,
      NULL,
      3,
      1,
      3.221350,
      NULL,
      NULL,
      0.456126,
      NULL,
      NULL,
      0,
      0.599771,
      0,
      0.619457,
      NULL,
      0,
      1,
      0,
      1.454217,
      1,
      0.634330,
      0,
      NULL,
      0.076587,
      1.140097,
      0.318206,
      1.151171,
      1.800128,
      2.924575,
      3.819592,
      1,
      0.897091,
      NULL,
      2.315035,
      1,
      NULL,
      0,
      NULL,
      3.890988,
      NULL,
      0,
      16.069835,
      0,
      '',
      '',
      ' 5-26-1997');
commit;
end;
/


