set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013776';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      NULL,
      NULL,
      2.836093,
      0,
      NULL,
      NULL,
      34,
      1,
      3,
      3.335932,
      3.344042,
      NULL,
      1.392755,
      0,
      NULL,
      NULL,
      1.065919,
      1.727097,
      0,
      NULL,
      0.195459,
      0.889302,
      NULL,
      1,
      NULL,
      0.067394,
      1,
      0.461548,
      3,
      1,
      NULL,
      0.362008,
      0.416256,
      1,
      1,
      0.319044,
      0,
      0.568977,
      2.254367,
      NULL,
      0.355474,
      2,
      2,
      0.448041,
      1.408822,
      0.211207,
      1.066939,
      1,
      0.479293,
      0.464318,
      0,
      NULL,
      0.737258,
      1,
      1,
      1,
      0,
      NULL,
      2.140249,
      NULL,
      0,
      0,
      1.612542,
      0,
      NULL,
      NULL,
      2.238989,
      0.360298,
      0.464443,
      0.940932,
      0,
      3,
      1.576688,
      0.671132,
      1.848180,
      0,
      0.789521,
      1,
      0.829925,
      NULL,
      0,
      1,
      0.998856,
      1.182314,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      1.356182,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1.656517,
      0,
      NULL,
      1.308905,
      NULL,
      2.695837,
      '211',
      '142',
      ' 7-19-1977');
commit;
end;
/


