set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.766974,
      3,
      11.944209,
      NULL,
      2.490617,
      NULL,
      39.670327,
      30,
      NULL,
      0,
      1,
      0.931139,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948519,
      NULL,
      NULL,
      NULL,
      0.443698,
      NULL,
      1.959163,
      0,
      0,
      1,
      2,
      0.275195,
      2.246143,
      0.438281,
      NULL,
      1,
      0,
      0,
      3,
      0.225575,
      1.877365,
      1,
      1.785128,
      1,
      2.079253,
      0,
      1.440185,
      1.693372,
      2.550259,
      0.342558,
      1.760996,
      1.078357,
      2,
      1,
      1,
      1.960746,
      0.416094,
      1.375162,
      1,
      1,
      0.275458,
      0.322269,
      3.329968,
      1,
      1,
      NULL,
      2,
      0.968752,
      3.002423,
      1,
      1.675548,
      1.817517,
      0.816526,
      0.927401,
      0,
      3.607560,
      2.532186,
      1,
      3,
      0,
      0,
      0,
      0.634370,
      NULL,
      1,
      0,
      0,
      0.908537,
      NULL,
      1,
      1.095542,
      0,
      0,
      NULL,
      NULL,
      1.295827,
      NULL,
      0,
      NULL,
      2.607629,
      NULL,
      1,
      0.458022,
      0.716336,
      3,
      1,
      0,
      22,
      NULL,
      '',
      NULL,
      ' 3-27-2001');
commit;
end;
/


