set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9216091';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0443323',
      0.115776,
      0,
      0.636002,
      2,
      1.852098,
      NULL,
      NULL,
      39,
      NULL,
      1.738193,
      0,
      0,
      0,
      0,
      1,
      2,
      0.938615,
      1.771021,
      1,
      0.751038,
      1,
      0.041136,
      1,
      NULL,
      0.986267,
      3,
      1,
      NULL,
      1,
      1.758092,
      1.015623,
      1.237725,
      1.767487,
      1,
      1,
      2,
      0,
      3.830901,
      0.814184,
      3,
      1.075479,
      2.868755,
      1,
      1.852258,
      0,
      3.127990,
      3,
      1.317701,
      1.170566,
      1,
      NULL,
      NULL,
      1.653001,
      NULL,
      1,
      1.481541,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0.072383,
      0.726954,
      0.519305,
      1.150544,
      NULL,
      2.331938,
      0.281555,
      1.739451,
      0,
      NULL,
      NULL,
      1,
      1.796786,
      NULL,
      1.181141,
      2,
      0,
      0.990802,
      2.649346,
      NULL,
      0.526286,
      1.266349,
      1.018570,
      0.543449,
      1,
      1.028461,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.966899,
      1.292418,
      NULL,
      1,
      NULL,
      2.556485,
      NULL,
      1,
      '421',
      '121',
      NULL);
commit;
end;
/


