set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000072';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2223003',
      0.692595,
      3,
      24,
      1,
      1.121679,
      NULL,
      23.417737,
      NULL,
      1,
      2,
      1.692986,
      0.063780,
      0,
      1.256194,
      0.188748,
      0,
      1,
      1,
      3,
      0,
      1,
      1,
      1,
      1.042579,
      0,
      1,
      1,
      2.366191,
      1,
      0,
      NULL,
      1,
      0.358306,
      1.781764,
      1.979321,
      0,
      0,
      0.636568,
      1.619989,
      0,
      0.295496,
      3.357781,
      1.050663,
      2,
      0.807854,
      NULL,
      NULL,
      1,
      1.430009,
      2.427733,
      0,
      0.303136,
      1,
      0,
      NULL,
      0.907698,
      1.858503,
      1.796803,
      1.750245,
      0.083061,
      0.299087,
      1,
      1.235923,
      0,
      3.978632,
      0.428493,
      1,
      3.410310,
      1,
      0,
      1,
      NULL,
      3.892180,
      2,
      0.095603,
      NULL,
      1.897157,
      1.727256,
      0,
      0.884095,
      0,
      NULL,
      0,
      0.561183,
      0.956726,
      NULL,
      1,
      0.859042,
      0.334887,
      NULL,
      0.764428,
      2,
      1,
      1,
      0,
      0.069690,
      2.076730,
      NULL,
      1.760584,
      3.875790,
      2.527789,
      3,
      0.197969,
      1,
      NULL,
      4,
      '',
      '',
      ' 5- 2-1984');
commit;
end;
/


