set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2104223',
      1.917895,
      NULL,
      30.254816,
      1.863963,
      1,
      NULL,
      NULL,
      9.470183,
      0,
      0.022963,
      1.060591,
      1.496806,
      NULL,
      1.028414,
      1,
      0,
      NULL,
      0.755178,
      2.208319,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.362394,
      2.640000,
      NULL,
      0,
      1.265975,
      3,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      1.332973,
      0.397243,
      NULL,
      3,
      3,
      0,
      3.161246,
      3.377170,
      0,
      1,
      1,
      1,
      1.211532,
      2.865391,
      0,
      1.232080,
      0.287752,
      1.516380,
      1.077886,
      1.214559,
      NULL,
      0.860156,
      3,
      2,
      1.398884,
      0,
      0,
      0.858238,
      NULL,
      1,
      0.729114,
      1,
      1,
      0,
      NULL,
      NULL,
      0.964173,
      NULL,
      0,
      2,
      1,
      0.510657,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1.593326,
      0.194448,
      NULL,
      1.639275,
      1.130812,
      1.762469,
      1,
      NULL,
      0,
      1,
      0.017570,
      1,
      0.162898,
      0.357377,
      1,
      NULL,
      3.889338,
      0,
      NULL,
      21.568035,
      0.769213,
      '',
      '',
      ' 1-18-1983');
commit;
end;
/


