set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1323044',
      2.891133,
      1,
      0.124458,
      2.995230,
      NULL,
      4.311996,
      53.072208,
      25.857792,
      NULL,
      NULL,
      NULL,
      0.900865,
      1,
      0,
      0.070867,
      NULL,
      0.869512,
      1.668912,
      1,
      0.381548,
      1,
      1,
      0,
      NULL,
      0.260533,
      1.269384,
      0,
      0,
      0.138052,
      3.219835,
      0,
      1.995218,
      1,
      NULL,
      1.533129,
      NULL,
      1.041483,
      1,
      0,
      1.687280,
      1,
      NULL,
      1,
      2,
      1.925196,
      0.177797,
      0,
      NULL,
      1,
      3.292202,
      1,
      1,
      1,
      1.022541,
      1,
      NULL,
      0.857876,
      1,
      3.838696,
      0,
      0,
      1,
      1.655054,
      NULL,
      0,
      2.486689,
      0,
      NULL,
      1.940092,
      1.874264,
      1.636577,
      1.914636,
      NULL,
      1.419781,
      0,
      NULL,
      0.099501,
      NULL,
      NULL,
      0.501100,
      1.212920,
      0,
      0.664220,
      1.529592,
      NULL,
      1,
      0.392100,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      1.993763,
      NULL,
      1,
      1.572265,
      0.674026,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      ' 7-13-1990');
commit;
end;
/


