set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6717343';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3213131',
      3,
      1,
      33,
      2.731574,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      3,
      1.425115,
      NULL,
      0.287393,
      0.178658,
      3.601069,
      NULL,
      1.952149,
      0.870804,
      2.666865,
      0.730484,
      1.964494,
      2.630775,
      0.028514,
      3,
      0.841511,
      3.085284,
      NULL,
      1,
      0.389874,
      3,
      1,
      3,
      NULL,
      1,
      1.382471,
      3.016247,
      1,
      NULL,
      0.071146,
      NULL,
      1.912129,
      3,
      0,
      1,
      1,
      1.031027,
      1.507577,
      NULL,
      0.833980,
      3.493512,
      1.282955,
      1,
      NULL,
      1,
      1.405802,
      NULL,
      0.553154,
      1.192702,
      3.919558,
      3.471599,
      0.557001,
      0.402009,
      0.571605,
      NULL,
      0.335591,
      3.668860,
      1,
      1.205593,
      NULL,
      0,
      1,
      NULL,
      3,
      0.580373,
      0.570492,
      1.858585,
      0,
      1,
      NULL,
      1,
      NULL,
      0.957495,
      NULL,
      1,
      0.599973,
      NULL,
      NULL,
      1,
      1.839913,
      0,
      1,
      NULL,
      0.052557,
      1.487799,
      0,
      1.700142,
      1.440902,
      0.600063,
      2,
      1,
      3.006392,
      2,
      0,
      1.364894,
      4.839015,
      2,
      '',
      '',
      NULL);
commit;
end;
/


