set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130040';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0043011',
      1,
      3,
      9.250168,
      0,
      1.187835,
      NULL,
      NULL,
      65.021658,
      1.874337,
      0.042232,
      1,
      NULL,
      1.127886,
      0,
      0.605657,
      0,
      NULL,
      1.410732,
      0,
      1.809324,
      1,
      3,
      1,
      2,
      1,
      2.885707,
      0,
      0,
      NULL,
      0.250330,
      0.908997,
      0.810432,
      0.965923,
      0.678134,
      1.710234,
      3.714705,
      1,
      1.143598,
      0,
      3.027948,
      3.536844,
      1,
      3,
      0.043817,
      1,
      3,
      1.845481,
      0.715388,
      0,
      1,
      1,
      NULL,
      1.035522,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.386963,
      0.149954,
      1.093516,
      0,
      0,
      1.040910,
      2.924137,
      1.848066,
      1.990845,
      0,
      1.604016,
      NULL,
      0.653753,
      1.266126,
      1.080509,
      1.795302,
      NULL,
      NULL,
      0,
      0.818629,
      1,
      0,
      1.838434,
      0,
      0.587553,
      0.754148,
      NULL,
      1,
      0,
      0,
      1,
      0.696799,
      3.007162,
      2.328721,
      0,
      1,
      0,
      3.698453,
      2.321894,
      0.771138,
      1,
      3,
      3,
      0.785634,
      NULL,
      15.880461,
      NULL,
      NULL,
      '',
      ' 7-24-1988');
commit;
end;
/


