set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8911010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4003222',
      0,
      3,
      23,
      NULL,
      0.617418,
      NULL,
      NULL,
      81.400172,
      1.851295,
      1,
      0.857759,
      1.969995,
      NULL,
      NULL,
      2.834551,
      3.011588,
      NULL,
      0.372125,
      NULL,
      0.945243,
      NULL,
      2,
      NULL,
      3.546613,
      0,
      2,
      1,
      NULL,
      1,
      3.997744,
      1,
      1,
      NULL,
      1.671969,
      NULL,
      0.458748,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.729837,
      NULL,
      1,
      1.621726,
      2.909209,
      1.298795,
      3.297134,
      0.614046,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      2.448538,
      1.140600,
      1,
      1.824337,
      NULL,
      0.939143,
      1.406287,
      3,
      1,
      3,
      0,
      1.899092,
      0.867761,
      NULL,
      NULL,
      1.454397,
      NULL,
      0.148398,
      0.102036,
      1.557933,
      0,
      0,
      1,
      0.839427,
      0,
      1,
      NULL,
      1,
      0.129200,
      NULL,
      1,
      1.840041,
      NULL,
      NULL,
      3.555922,
      1.280882,
      0.466823,
      0,
      0.079853,
      0.098942,
      1.491591,
      1,
      3.380062,
      NULL,
      1,
      1.961927,
      1.851211,
      1,
      NULL,
      '',
      ' 2-19-1984');
commit;
end;
/


